% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{improper_uniform_log_density}
\alias{improper_uniform_log_density}
\title{Improper uniform log density}
\usage{
improper_uniform_log_density(theta)
}
\arguments{
\item{theta}{A vector of 4 parameters representing (A,B,g,k) or (A,B,g,h)}
}
\value{
Value of an (unnormalised) log density
}
\description{
Returns log density of an improper prior for the g-and-k or g-and-h distribution
}
\details{
\code{improper_uniform_log_density} takes a 4 parameter vector as input and returns a log density value.
The output corresponds to an improper uniform with constraints that the second and fourth parameters should be non-negative.
These ensure that the resulting parameters are valid to use in the g-and-k or g-and-h distribution is valid.
This function is supplied as a convenient default prior to use in the \code{mcmc} function.
}
\examples{
improper_uniform_log_density(c(0,1,0,0)) ##Valid parameters - returns 0
improper_uniform_log_density(c(0,-1,0,0)) ##Invalid parameters - returns -Inf
}

