% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-auth.R
\name{gitcreds_fill}
\alias{gitcreds_fill}
\alias{gitcreds_approve}
\alias{gitcreds_reject}
\title{Access the low level credential API}
\usage{
gitcreds_fill(input, args = character(), dummy = TRUE)

gitcreds_approve(creds, args = character())

gitcreds_reject(creds, args = character())
}
\arguments{
\item{input}{Named list to pass to \verb{git credential fill}.}

\item{args}{Extra args, used \emph{before} \code{fill}, to allow
\verb{git -c ... fill}.}

\item{dummy}{Whether to append a dummy credential helper to the
list of credential helpers.}

\item{creds}{\code{gitcreds} object (named list) to add or remove.}
}
\value{
The standard output of the \code{git} command, line by line.
}
\description{
These function are primarily for package authors, who want more
control over the user interface, so they want to avoid calling
\code{\link[=gitcreds_get]{gitcreds_get()}} and \code{\link[=gitcreds_set]{gitcreds_set()}} directly.
}
\details{
\code{gitcreds_fill()} calls \verb{git credential fill} to query git
credentials.

\code{gitcreds_approve()} calls \verb{git credential approve}
to add new credentials.
}
\seealso{
\code{\link[=gitcreds_parse_output]{gitcreds_parse_output()}} to parse the output of
\code{gitcreds_fill()}.
}
