% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stash.r
\docType{methods}
\name{stash_list}
\alias{stash_list}
\alias{stash_list,git_repository-method}
\title{List stashes in repository}
\usage{
stash_list(repo)

\S4method{stash_list}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository.}
}
\value{
list of stashes in repository
}
\description{
List stashes in repository
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

# Configure a user
config(repo, user.name="Alice", user.email="alice@example.org")

# Create a file, add and commit
writeLines("Hello world!", file.path(path, "test-1.txt"))
add(repo, 'test-1.txt')
commit(repo, "Commit message")

# Make one more commit
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "test-1.txt"))
add(repo, 'test-1.txt')
commit(repo, "Next commit message")

# Create one more file
writeLines("Hello world!", file.path(path, "test-2.txt"))

# Check that there are no stashes
stash_list(repo)

# Stash
stash(repo)

# Only untracked changes, therefore no stashes
stash_list(repo)

# Stash and include untracked changes
stash(repo, "Stash message", untracked=TRUE)

# View stash
stash_list(repo)
}
}
\keyword{methods}

