% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_addressapi.R
\name{gisco_addressapi}
\alias{gisco_addressapi}
\alias{gisco_addressapi_search}
\alias{gisco_addressapi_reverse}
\alias{gisco_addressapi_bbox}
\alias{gisco_addressapi_countries}
\alias{gisco_addressapi_provinces}
\alias{gisco_addressapi_cities}
\alias{gisco_addressapi_roads}
\alias{gisco_addressapi_housenumbers}
\alias{gisco_addressapi_postcodes}
\alias{gisco_addressapi_copyright}
\title{GISCO Address API}
\usage{
gisco_addressapi_search(
  country = NULL,
  province = NULL,
  city = NULL,
  road = NULL,
  housenumber = NULL,
  postcode = NULL,
  verbose = FALSE
)

gisco_addressapi_reverse(x, y, country = NULL, verbose = FALSE)

gisco_addressapi_bbox(
  country = NULL,
  province = NULL,
  city = NULL,
  road = NULL,
  postcode = NULL,
  verbose = FALSE
)

gisco_addressapi_countries(verbose = FALSE)

gisco_addressapi_provinces(country = NULL, city = NULL, verbose = FALSE)

gisco_addressapi_cities(country = NULL, province = NULL, verbose = FALSE)

gisco_addressapi_roads(
  country = NULL,
  province = NULL,
  city = NULL,
  verbose = FALSE
)

gisco_addressapi_housenumbers(
  country = NULL,
  province = NULL,
  city = NULL,
  road = NULL,
  postcode = NULL,
  verbose = FALSE
)

gisco_addressapi_postcodes(
  country = NULL,
  province = NULL,
  city = NULL,
  verbose = FALSE
)

gisco_addressapi_copyright(verbose = FALSE)
}
\arguments{
\item{country}{Country code (\code{country = "LU"}).}

\item{province}{A province within a country. For a list of provinces within a
certain country use the provinces endpoint
(\code{gisco_addressapi_provinces(country = "LU")}).}

\item{city}{A city within a province. For a list of cities within a certain
province use the cities endpoint
(\code{gisco_addressapi_cities(province = "capellen")}).}

\item{road}{A road within a city.}

\item{housenumber}{The house number or house name within a road or street.}

\item{postcode}{Can be used in combination with the previous parameters.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{x, y}{x and y coordinates (as longitude and latitude) to be converted
into a human-readable address.}
}
\value{
A \code{data.frame} object in most cases, except  \code{gisco_addressapi_search()},
\code{gisco_addressapi_reverse()} and \code{gisco_addressapi_bbox()}, that return a
\code{\link[sf:sf]{sf}} object.
}
\description{
Access the \href{https://gisco-services.ec.europa.eu/addressapi/docs/screen/home}{GISCO Address API}, that
allows to carry out both geocoding and reverse geocoding using a pan-european
address database.

Each endpoint available is implemented through a specific function, see
\strong{Details}.

The API supports fuzzy searching (also referred to as approximate string
matching) for all parameters of each endpoint.
}
\details{
Brief description of the API endpoints (source \href{https://gisco-services.ec.europa.eu/addressapi/docs/screen/endpoints}{GISCO Address API \> Endpoints}:\tabular{ll}{
   \strong{Endpoint} \tab \strong{Description} \cr
   \verb{/countries} \tab Returns all country codes that are compatible with the address API. Check the coverage map for available countries and see \href{https://publications.europa.eu/code/en/en-5000500.htm}{here for a list of official country codes}. \cr
   \verb{/provinces} \tab Returns all provinces within the specified country. Can also be used to get the province of a specified city. \cr
   \verb{/cities} \tab Returns all cities within a specified province or country. \cr
   \verb{/roads} \tab Returns all roads or streets within a specified city. \cr
   \verb{/housenumbers} \tab Returns all house numbers or names within the specified road. It is possible that in certain countries an address may not have a road component. In this case, if a road is not specified then the number of house numbers returned by \strong{the API is limited to 1000}. \cr
   \verb{/postcodes} \tab Returns all postcodes within the specified address component (Country or Province or City). \cr
   \verb{/search} \tab The search endpoint allows structured queries to the address database. Please note that various combinations of each of the parameters can be used in order to retrieve the addresses that share an address component. \strong{The API is limited to a maximum of 100 addresses}. \cr
   \verb{/reverse} \tab The API's reverse theme allows you to specify x and y coordinates in order to retrieve a structured address. \cr
   \verb{/bbox} \tab Returns a \href{https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry}{WKT} bounding box for an address component depending on the parameters specified. \cr
   \verb{/copyright} \tab Returns the copyright text for each available country in the Address API. \cr
}


The resulting object may present the following variables:\tabular{ll}{
   \strong{Property name} \tab \strong{Description} \cr
   \code{LD} \tab Refers to "Locator Designator" and represents the house number part of the address \cr
   \code{TF} \tab Refers to "Thoroughfare" and represents the street or road part of the address \cr
   \code{L0} \tab Refers to Level 0 of the API administrative levels. Values are country codes consisting of 2 characters. \cr
   \code{L1} \tab Refers to Level 1 of the API administrative levels. Values are province names. Please note that "province" is a generic term that may differ between countries. \cr
   \code{L2} \tab Refers to Level 2 of the API administrative levels. Values are town or city names. Please note that "city" is a generic term that may differ between countries. \cr
   \code{PC} \tab Postal Code \cr
   \code{N0} \tab Refers to "NUTS 0" \cr
   \code{N1} \tab Refers to "NUTS 1" \cr
   \code{N2} \tab Refers to "NUTS 2" \cr
   \code{N3} \tab Refers to "NUTS 3" \cr
   \code{X} and \code{Y} \tab Refers to the x and y coordinates of the address point \cr
   \code{OL} \tab Refers to the address' \href{https://github.com/google/open-location-code}{Open Location Code} \cr
}
}
\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(dplyr)

# Cities in a region

gisco_addressapi_cities(country = "PT", province = "LISBOA") \%>\%
  as_tibble()



# Geocode and reverse geocode with sf objects
library(ggplot2)

# Structured search

struct <- gisco_addressapi_search(
  country = "ES", city = "BARCELONA",
  road = "GRACIA"
)

struct \%>\%
  ggplot() +
  geom_sf(aes(color = PC)) +
  labs(color = "POSTAL CODES")

# Reverse geocoding

reverse <- gisco_addressapi_reverse(x = struct$X[1], y = struct$Y[1])

glimpse(reverse)
}
\dontshow{\}) # examplesIf}
}
\seealso{
See the docs:
\url{https://gisco-services.ec.europa.eu/addressapi/docs/screen/home}.
}
\concept{tools}
