% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp.R
\name{temporary}
\alias{temporary}
\alias{temp_csv}
\alias{temp_rds}
\alias{temp_lines}
\title{Write an object to a temporary file}
\usage{
temp_csv(x, ...)

temp_rds(x, ...)

temp_lines(x, ...)
}
\arguments{
\item{x}{An object}

\item{...}{Extra arguments passed to the relevant writing function (such as
\code{\link[readr]{write_csv}} for \code{temp_csv})}
}
\value{
A string with the temporary filename containing the output. This will
be in the temporary per-session directory.
}
\description{
Write an object to a temporary CSV, RDS, or raw text file, and return
the path to that file. This can be used, for example, as an argument to a
giftwrapped function.
}
\examples{

wrap_commands("cat")

cat(temp_csv(mtcars))

}
\seealso{
\link{tempfile}
}
