% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats_graphics.R
\name{ggsignif_adder}
\alias{ggsignif_adder}
\title{Adding \code{geom_signif} to \code{ggplot}}
\usage{
ggsignif_adder(plot, df_pairwise, data, x, y,
  pairwise.annotation = "p.value", pairwise.display = "significant")
}
\arguments{
\item{plot}{A \code{ggplot} object on which \code{geom_signif} needed to be added.}

\item{df_pairwise}{A dataframe containing results from pairwise comparisons
(produced by \code{pairwiseComparisons::pairwise_comparisons()} function).}

\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{pairwise.annotation}{Character that decides the annotations to use for
pairwise comparisons. Either \code{"p.value"} (default) or \code{"asterisk"}.}

\item{pairwise.display}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}
}
\description{
Adding \code{geom_signif} to \code{ggplot}
}
\examples{
set.seed(123)
library(ggplot2)

# plot
p <- ggplot(iris, aes(Species, Sepal.Length)) + geom_boxplot()

# dataframe with pairwise comparison test results
df_pair <- pairwiseComparisons::pairwise_comparisons(
  data = iris,
  x = Species,
  y = Sepal.Length
)

# adding a geom for pairwise comparisons
ggstatsplot:::ggsignif_adder(
  plot = p,
  data = iris,
  x = Species,
  y = Sepal.Length,
  df_pairwise = df_pair
)
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
\keyword{internal}
