% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_contingency_tab}
\alias{bf_contingency_tab}
\title{Bayesian contingency table analysis.}
\usage{
bf_contingency_tab(data, main, condition, sampling.plan = "indepMulti",
  fixed.margin = "rows", prior.concentration = 1, caption = NULL,
  output = "caption", k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{condition}{The variable to use as the \strong{columns} in the contingency
table.}

\item{sampling.plan}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"caption"} (which will contain text for evidence
in favor of null)  or \code{"results"} (which will return the dataframe with
results).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayesian contingency table analysis.
}
\examples{

# for reproducibility
set.seed(123)

# to get caption (default)
bf_contingency_tab(
  data = mtcars,
  main = am,
  condition = cyl,
  fixed.margin = "cols"
)

# to see results
bf_contingency_tab(
  data = mtcars,
  main = am,
  condition = cyl,
  sampling.plan = "jointMulti",
  fixed.margin = "rows",
  prior.concentration = 1
)
}
\seealso{
\code{\link{bf_corr_test}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_two_sample_ttest}}
}
\author{
Indrajeet Patil
}
