% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghistostats.R
\name{gghistostats}
\alias{gghistostats}
\title{Histogram for distribution of a numeric variable}
\usage{
gghistostats(data = NULL, x, binwidth = NULL, bar.measure = "count",
  xlab = NULL, title = NULL, subtitle = NULL, caption = NULL,
  type = "parametric", test.value = 0, bf.prior = 0.707,
  bf.message = FALSE, robust.estimator = "onestep",
  conf.level = 0.95, nboot = 100, k = 2,
  ggtheme = ggplot2::theme_bw(), ggstatsplot.layer = TRUE,
  fill.gradient = FALSE, low.color = "#0072B2",
  high.color = "#D55E00", bar.fill = "grey50",
  results.subtitle = TRUE, centrality.para = "mean",
  centrality.color = "blue", centrality.size = 1,
  centrality.linetype = "dashed", centrality.line.labeller = TRUE,
  centrality.k = 2, test.value.line = FALSE,
  test.value.color = "black", test.value.size = 1,
  test.value.linetype = "dashed", test.line.labeller = TRUE,
  test.k = 0, ggplot.component = NULL, messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken. This argument is optional.}

\item{x}{A numeric variable.}

\item{binwidth}{The width of the histogram bins. Can be specified as a
numeric value, or a function that calculates width from \code{x}. The default is
to use the \code{max(x) - min(x) / sqrt(N)}. You should always check this value
and explore multiple widths to find the best to illustrate the stories in
your data.}

\item{bar.measure}{Character describing what value needs to be represented as
height in the bar chart. This can either be \code{"count"}, which shows number
of points in bin, or \code{"density"}, which density of points in bin, scaled to
integrate to 1, or "\code{proportion}", which shows relative frequencies of
observations in each bin, or "\code{mix}", which shows \emph{both} count and
proportion in the same plot.}

\item{xlab}{Label for \code{x} axis variable.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis \strong{for parametric test} (Default: \code{FALSE}).}

\item{robust.estimator}{If \code{test = "robust"} robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{conf.level}{A scalar value between 0 and 1. If unspecified, the
default is to return \code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for robust one-sample location test
(Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_economist()},
\code{hrbrthemes::theme_ipsum_ps()}, \code{ggthemes::theme_fivethirtyeight()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{fill.gradient}{Logical decides whether color fill gradient is to be
displayed (Default: \code{FALSE}). If \code{FALSE}, the legend and the color gradient
will also be removed. The default is set to \code{FALSE} because the gradient
provides redundant information in light of y-axis labels.}

\item{low.color, high.color}{Colors for low and high ends of the gradient.
Defaults are colorblind-friendly.}

\item{bar.fill}{If \code{fill.gradient = FALSE}, then \code{bar.fill} decides which
color will uniformly fill all the bars in the histogram (Default:
\code{"grey50"}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as a vertical line.}

\item{centrality.color}{Decides color for the vertical line for centrality
parameter (Default: \code{"blue"}).}

\item{centrality.size}{Decides size for the vertical line for centrality
parameter (Default: \code{1.2}).}

\item{centrality.linetype}{Decides linetype for the vertical line for
centrality parameter (Default: \code{"dashed"}).}

\item{centrality.line.labeller}{A logical that decides whether line labels
should be displayed for the \strong{centrality.para} line (Default: \code{TRUE}).}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{test.value.line}{Decides whether test value is to be displayed as a
vertical line (Default: \code{FALSE}).}

\item{test.value.color}{Decides color for the vertical line denoting test
value (Default: \code{"black"}).}

\item{test.value.size}{Decides size for the vertical line for test value
(Default: \code{1.2}).}

\item{test.value.linetype}{Decides linetype for the vertical line for test
value (Default: \code{"dashed"}).}

\item{test.line.labeller}{A logical that decides whether line labels should
be displayed for \strong{test.value} line (Default: \code{TRUE}).}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Histogram with statistical details from one-sample test included
in the plot as a subtitle.
}
\examples{

# most basic function call with the defaults
# this is the only function where data argument can be `NULL`.
ggstatsplot::gghistostats(
  x = ToothGrowth$len,
  xlab = "Tooth length",
  centrality.para = "median"
)

# a detailed function call
ggstatsplot::gghistostats(
  data = datasets::iris,
  x = Sepal.Length,
  bar.measure = "mix",
  type = "p",
  bf.message = TRUE,
  caption = substitute(paste(italic("Note"), ": Iris dataset by Fisher.")),
  bf.prior = 0.8,
  test.value = 3,
  test.value.line = TRUE,
  binwidth = 0.10,
  bar.fill = "grey50"
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/gghistostats.html}
}
\seealso{
\code{\link{grouped_gghistostats}}
}
\author{
Indrajeet Patil
}
