% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghistostats.R
\name{gghistostats}
\alias{gghistostats}
\title{Histogram for distribution of a numeric variable}
\usage{
gghistostats(data = NULL, x, binwidth = NULL, bar.measure = "count",
  xlab = NULL, title = NULL, subtitle = NULL, caption = NULL,
  type = "parametric", test.value = 0, bf.prior = 0.707,
  bf.message = TRUE, robust.estimator = "onestep", nboot = 500,
  k = 3, low.color = "#0072B2", high.color = "#D55E00",
  results.subtitle = TRUE, legend.title.margin = FALSE,
  t.margin = unit(0, "mm"), b.margin = unit(3, "mm"),
  centrality.para = NULL, centrality.color = "blue",
  centrality.size = 1.2, centrality.linetype = "dashed",
  test.value.line = FALSE, test.value.color = "black",
  test.value.size = 1.2, test.value.linetype = "dashed",
  line.labeller = FALSE, line.labeller.y = -2,
  ggtheme = ggplot2::theme_bw(), fill.gradient = TRUE,
  messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken. This argument is optional.}

\item{x}{A numeric variable.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value,
or a function that calculates width from \code{x}. The default is to use bins
bins that cover the range of the data. You should always override this
value, exploring multiple widths to find the best to illustrate the stories
in your data.}

\item{bar.measure}{Character describing what value needs to be represented as
height in the bar chart. This can either be \code{"count"}, which shows number
of points in bin, or \code{"density"}, which density of points in bin, scaled to
integrate to 1, or "\code{proportion}", which shows relative frequencies of
observations in each bin.}

\item{xlab}{Label for \code{x} axis variable.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle \emph{if} you don't want results
from one sample test to be displayed.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}). Abbreviations accepted are \code{"p"} or \code{"np"} or
\code{"r"} or \code{"bf"}, respectively.}

\item{test.value}{A number specifying the value of the null hypothesis.}

\item{bf.prior}{A number between 0.5 and 2 (default 0.707), the prior width
to use in calculating Bayes factors.}

\item{bf.message}{Logical. Decides whether to display Bayes Factor in favor
of null hypothesis for parametric test if the null hypothesis can't be
rejected (Default: \code{bf.message = TRUE}).}

\item{robust.estimator}{If \code{test = "robust"} robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{nboot}{Number of bootstrap samples for robust one-sample location test.}

\item{k}{Number of decimal places expected for results.}

\item{low.color, high.color}{Colors for low and high ends of the gradient.
Defaults are colorblind-friendly.}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as subtitle (Default: \code{results.subtitle = TRUE}). If set to
\code{FALSE}, no statistical tests will be run.}

\item{legend.title.margin}{Adjusting the margin between legend title and the
colorbar (Default: \code{FALSE}).}

\item{t.margin, b.margin}{Margins in grid units. For more details, see
\code{?grid::unit()}.}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as a vertical line.}

\item{centrality.color}{Decides color for the vertical line for centrality
parameter (Default: \code{"blue"}).}

\item{centrality.size}{Decides size for the vertical line for centrality
parameter (Default: \code{1.2}).}

\item{centrality.linetype}{Decides linetype for the vertical line for
centrality parameter (Default: \code{"dashed"}).}

\item{test.value.line}{Decides whether test value is to be displayed as a
vertical line (Default: \code{FALSE}).}

\item{test.value.color}{Decides color for the vertical line denoting test
value (Default: \code{"black"}).}

\item{test.value.size}{Decides size for the vertical line for test value
(Default: \code{1.2}).}

\item{test.value.linetype}{Decides linetype for the vertical line for test
value (Default: \code{"dashed"}).}

\item{line.labeller}{A logical that decides whether line labels should be
displayed (Default: \code{FALSE}).}

\item{line.labeller.y}{A numeric denoting the y-coordinate for displaying
line labels (Default: \code{-2}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Allowed values are the official \code{ggplot2} themes,
including \code{theme_grey()}, \code{theme_minimal()}, \code{theme_classic()},
\code{theme_void()}, etc.}

\item{fill.gradient}{Logical decides whether color fill gradient is to be
displayed (Default: \code{TRUE}). If \code{FALSE}, the legend will also be removed.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Histogram with statistical details from one-sample test included
in the plot as a subtitle.
}
\note{
If you are using R Notebook and see a blank image being inserted when a
chunk is executed, this behavior can be turned off by setting
\code{legend.title.margin = FALSE}.
}
\examples{

# most basic function call with the defaults
ggstatsplot::gghistostats(
  data = datasets::ToothGrowth,
  x = len,
  xlab = "Tooth length"
)

# a detailed function call
ggstatsplot::gghistostats(
  data = datasets::iris,
  x = Sepal.Length,
  type = "bf",
  bf.prior = 0.8,
  test.value = 3,
  centrality.para = "mean",
  test.value.line = TRUE,
  binwidth = 0.10
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/gghistostats.html}
}
\seealso{
\code{\link{grouped_gghistostats}}
}
\author{
Indrajeet Patil
}
