% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-cps-spct.r
\name{autoplot.cps_spct}
\alias{autoplot.cps_spct}
\title{Create a complete ggplot for detector-counts per second spectra.}
\usage{
\method{autoplot}{cps_spct}(
  object,
  ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(), UVA(),
    PAR())),
  range = NULL,
  unit.out = "cps",
  pc.out = FALSE,
  label.qty = "mean",
  span = NULL,
  annotations = NULL,
  time.format = "",
  tz = "UTC",
  norm = NULL,
  text.size = 2.5,
  idfactor = NULL,
  ylim = c(NA, NA),
  object.label = deparse(substitute(object)),
  na.rm = TRUE
)
}
\arguments{
\item{object}{a cps_spct object.}

\item{...}{in the case of collections of spectra, additional arguments passed
to the plot methods for individual spectra, otherwise currently ignored.}

\item{w.band}{a single waveband object or a list of waveband objects.}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm).}

\item{unit.out}{character IGNORED.}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector ("summaries" is ignored).}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character Time zone to use for title and/or subtitle.}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried.}

\item{ylim}{numeric y axis limits,}

\item{object.label}{character The name of the object being plotted.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
response_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\seealso{
Other autoplot methods: 
\code{\link{autoplot.calibration_spct}()},
\code{\link{autoplot.filter_spct}()},
\code{\link{autoplot.object_spct}()},
\code{\link{autoplot.raw_spct}()},
\code{\link{autoplot.reflector_spct}()},
\code{\link{autoplot.response_spct}()},
\code{\link{autoplot.source_spct}()},
\code{\link{autoplot.waveband}()},
\code{\link{set_annotations_default}()}
}
\concept{autoplot methods}
