% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title-utils.R
\name{autotitle}
\alias{autotitle}
\alias{ggtitle_spct}
\title{Add title, subtitle and caption to a spectral plot}
\usage{
autotitle(object, object.label = deparse(substitute(object)),
  annotations = "title", time.format = "",
  tz = lubridate::tz(getWhenMeasured(object)),
  default.title = "title:objt")

ggtitle_spct(object, object.label = deparse(substitute(object)),
  annotations = "title", time.format = "",
  tz = lubridate::tz(getWhenMeasured(object)),
  default.title = "title:objt")
}
\arguments{
\item{object}{generic_spct The spectral object plotted.}

\item{object.label}{character The name of the object being plotted.}

\item{annotations}{character vector Annotations as described for
\code{plot()} methods, values unrelated to title are ignored.}

\item{time.format}{character Format as accepted by
\code{\link[base]{strptime}}.}

\item{tz}{character time zone used in labels.}

\item{default.title}{character vector The default used for \code{annotations
= "title"}.}
}
\value{
The return value of \code{ggplot2::labs()}.
}
\description{
Add a title, subtitle and caption to a spectral plot based on automatically
extracted metadata stored from an spectral object.
}
\details{
\code{autotitle()} retrieves from object \code{object} metadata and
  passes it to \code{ggplot2::ggtitle()} as arguments for \code{title},
  \code{subtitle} and \code{caption}. The specification for the tittle is
  passed as argument to \code{annotations}, and consists in the keyword
  \code{title} with optional modifiers selecting the kind of metatdata to
  use, separated by colons. Up to three keywords separated by colons are
  accepted, and correspond to title, subtitle and caption. The recognized
  keywords are: "objt", "class", "what", "when", "where", "how", "inst.name",
  "inst.sn", "comment" and "none" are recognized as modifiers to "title";
  "none" is a placeholder.
}
\note{
Method renamed as \code{autotitle()} to better reflect its function;
\code{ggtitle_spct()} is deprecated but will remain available for backwards
compatibility.
}
\examples{

p <- ggplot(sun.spct) +
  geom_line()

p + autotitle(sun.spct)
p + autotitle(sun.spct, annotations = "title:what")
p + autotitle(sun.spct, annotations = "title:where:when")
p + autotitle(sun.spct, annotations = "title:none:none:comment")

}
