% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wl-strip.R
\name{fast_wb2rect_df}
\alias{fast_wb2rect_df}
\title{Colours from wavebands}
\usage{
fast_wb2rect_df(w.band, chroma.type = "CMF", simplify = TRUE)
}
\arguments{
\item{w.band}{waveband or list of waveband objects. The waveband(s) determine
the wavelengths in variable \code{w.length} of the returned spectrum.}

\item{chroma.type}{character telling whether "CMF", "CC", or "both" should be
returned for human vision, or an object of class \code{chroma_spct} for any
other trichromic visual system.}

\item{simplify}{logical Flag indicating whether to merge neighbouring
rectangles of equal color.}
}
\value{
A data frame with columns "x", "y", "w.length", "wb.color",
"wl.high", "wl.low".
}
\description{
Compute colours for a list of narrow wavebands or a range of wavelengths.
}
\details{
Function \code{fast_wb2rect_df()} computes colours for
  wavebands based on the midpoint wavelength and uses vectorization when
  possible. It always returns color definitions with short names. The purpose
  of merging of rectangles is to speed up rendering and to reduce the size of
  vector graphics output. This function should be used with care as the color
  definitions returned are only approximate and original waveband names can
  be lost.

  Function \code{fast_wb2rect_df()} intended use is when colour definitions
  are needed in a simple data frame as in the compute functions of
  statistics that return colours.
}
\keyword{internal}
