% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-tw3.R
\name{scale_color_tw3}
\alias{scale_color_tw3}
\alias{scale_colour_tw3}
\alias{scale_fill_tw3}
\title{Tailwind CSS color scales}
\usage{
scale_color_tw3(
  palette = c("slate", "gray", "zinc", "neutral", "stone", "red", "orange", "amber",
    "yellow", "lime", "green", "emerald", "teal", "cyan", "sky", "blue", "indigo",
    "violet", "purple", "fuchsia", "pink", "rose"),
  alpha = 1,
  reverse = FALSE,
  ...
)

scale_colour_tw3(
  palette = c("slate", "gray", "zinc", "neutral", "stone", "red", "orange", "amber",
    "yellow", "lime", "green", "emerald", "teal", "cyan", "sky", "blue", "indigo",
    "violet", "purple", "fuchsia", "pink", "rose"),
  alpha = 1,
  reverse = FALSE,
  ...
)

scale_fill_tw3(
  palette = c("slate", "gray", "zinc", "neutral", "stone", "red", "orange", "amber",
    "yellow", "lime", "green", "emerald", "teal", "cyan", "sky", "blue", "indigo",
    "violet", "purple", "fuchsia", "pink", "rose"),
  alpha = 1,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Palette type. There are 22 available options:
\itemize{
\item \code{"slate"}
\item \code{"gray"}
\item \code{"zinc"}
\item \code{"neutral"}
\item \code{"stone"}
\item \code{"red"}
\item \code{"orange"}
\item \code{"amber"}
\item \code{"yellow"}
\item \code{"lime"}
\item \code{"green"}
\item \code{"emerald"}
\item \code{"teal"}
\item \code{"cyan"}
\item \code{"sky"}
\item \code{"blue"}
\item \code{"indigo"}
\item \code{"violet"}
\item \code{"purple"}
\item \code{"fuchsia"}
\item \code{"pink"}
\item \code{"rose"}
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_tw3]{pal_tw3()}} for details.
}
\examples{
library("ggplot2")

data("mtcars")
cor <- abs(cor(mtcars))
cor_melt <- data.frame(
  Var1 = rep(seq_len(nrow(cor)), times = ncol(cor)),
  Var2 = rep(seq_len(ncol(cor)), each = nrow(cor)),
  value = as.vector(cor)
)

ggplot(
  cor_melt,
  aes(x = Var1, y = Var2, fill = value)
) +
  geom_tile(colour = "black", size = 0.3) +
  theme_bw() +
  scale_fill_tw3("slate")
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
