% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-point.R
\name{scale_point}
\alias{scale_point_shape}
\alias{scale_point_size_continuous}
\alias{scale_point_colour_hue}
\alias{scale_point_color_hue}
\alias{scale_point_fill_hue}
\alias{scale_point_colour_gradient}
\alias{scale_point_color_gradient}
\alias{scale_point_fill_gradient}
\alias{scale_point_shape_discrete}
\alias{scale_point_color_discrete}
\alias{scale_point_colour_discrete}
\alias{scale_point_fill_discrete}
\alias{scale_point_color_continuous}
\alias{scale_point_colour_continuous}
\alias{scale_point_fill_continuous}
\title{Scales for point aesthetics}
\description{
These are various scales that can be applied to point aesthetics, such as
\code{point_color}, \code{point_fill}, \code{point_size}. The individual scales all have the
same usage as existing standard ggplot2 scales, only the name differs.
}
\examples{
library(ggplot2)

# default scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species)) +
  geom_density_ridges(
    aes(
      point_color = Species, point_fill = Species,
      point_shape = Species
    ),
    alpha = .4, jittered_points = TRUE
  ) +
  theme_ridges()

# modified scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species)) +
  geom_density_ridges(
    aes(
      point_color = Species, point_fill = Species,
      point_shape = Species
    ),
    alpha = .4, point_alpha = 1,
    jittered_points = TRUE
  ) +
  scale_fill_hue(l = 50) +
  scale_point_color_hue(l = 20) +
  scale_point_fill_hue(l = 70) +
  scale_discrete_manual("point_shape", values = c(21, 22, 23)) +
  theme_ridges()
}
\seealso{
See \code{\link[=scale_vline_color_hue]{scale_vline_color_hue()}} for specific scales for vline aesthetics
and \code{\link[=scale_discrete_manual]{scale_discrete_manual()}} for a general discrete scale.
}
