% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_auto.R
\name{layout_tbl_graph_auto}
\alias{layout_tbl_graph_auto}
\title{Automatically pick a layout based on graph type}
\usage{
layout_tbl_graph_auto(graph, circular, ...)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Defaults to \code{FALSE}. Only applicable if the graph is a tree
structure}

\item{...}{Arguments passed on to the chosen layout}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This function infers the layout from the graph structure and is the default
when calling \code{\link[=ggraph]{ggraph()}}. If an \code{x} and \code{y} argument is passed along, the
manual layout is chosen. Otherwise if the graph is either a rooted tree or a
rooted forest the layout will be \code{dendrogram} if the nodes contains a height
variable or \code{tree} if not. If the tree is unrooted the \code{unrooted} layout will
be used. If the tree is a DAG the \code{sygiyama} layout will be used. Otherwise
the \code{stress} layout will be used (or \code{sparse_tree} if the graph contains more
than 2000 nodes).
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_backbone}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_eigen}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_igraph}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_partition}},
  \code{\link{layout_tbl_graph_pmds}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\concept{layout_tbl_graph_*}
