% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtexttable.R
\name{ggtexttable}
\alias{ggtexttable}
\alias{ttheme}
\alias{colnames_style}
\alias{rownames_style}
\alias{tbody_style}
\title{Draw a Textual Table}
\usage{
ggtexttable(x, rows = rownames(x), cols = colnames(x), vp = NULL,
  theme = ttheme(), ...)

ttheme(base_style = "default", base_size = 11, base_colour = "black",
  padding = unit(c(4, 4), "mm"), colnames.style = colnames_style(size =
  base_size), rownames.style = rownames_style(size = base_size),
  tbody.style = tbody_style(size = base_size))

colnames_style(color = "black", face = "bold", size = 12,
  fill = "grey80", linewidth = 1, linecolor = "white", parse = FALSE)

rownames_style(color = "black", face = "italic", size = 12, fill = NA,
  linewidth = 1, linecolor = "white", parse = FALSE)

tbody_style(color = "black", face = "plain", size = 12,
  fill = c("grey95", "grey90"), linewidth = 1, linecolor = "white",
  parse = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} or \code{matrix}.}

\item{rows}{optional vector to specify row names}

\item{cols}{optional vector to specify column names}

\item{vp}{optional viewport}

\item{theme}{a list, as returned by the function \code{ttheme()}, defining the
parameters of the table theme. Allowed values include one of \code{ttheme()}
and \code{ttheme_clean()}.}

\item{...}{further arguments to control the gtable}

\item{base_style}{charcter string the table style/theme. The available themes
are illustrated in the
\href{http://www.sthda.com/english/rpkgs/ggpubr/files/ggtexttable-theme.pdf}{ggtexttable-theme.pdf}
 file. Allowed values include one of \code{c("default", "blank", "classic",
"minimal", "light", "lBlack", "lBlue", "lRed", "lGreen", "lViolet", "lCyan",
"lOrange", "lBlackWhite", "lBlueWhite", "lRedWhite", "lGreenWhite",
"lVioletWhite", "lCyanWhite", "lOrangeWhite", "mBlack", "mBlue", "mRed",
"mGreen", "mViolet", "mCyan", "mOrange", "mBlackWhite", "mBlueWhite",
"mRedWhite", "mGreenWhite", "mVioletWhite", "mCyanWhite", "mOrangeWhite" )}.
Note that, l = "light"; m = "medium".}

\item{base_size}{default font size}

\item{base_colour}{default font colour}

\item{padding}{length-2 unit vector specifying the horizontal and vertical padding of text within each cell}

\item{colnames.style}{a list, as returned by the function
\code{colnames_style()}, defining the style of the table column names.
Considered only when \code{base_size = "default"}.}

\item{rownames.style}{a list, as returned by the function
\code{rownames_style()}, defining the style of the table row names.
Considered only when \code{base_size = "default"}.}

\item{tbody.style}{a list, as returned by the function \code{tbody_style()},
defining the style of the table body. Considered only when \code{base_size =
"default"}.}

\item{color, face, size}{text font color, face and size, respectively. Allowed
values for face include c("plain", "bold", "italic", "bold.italic").}

\item{fill}{background color.}

\item{linewidth, linecolor}{line width and color, respectively.}

\item{parse}{logical, default behaviour for parsing text as plotmath}
}
\value{
an object of class ggplot.
}
\description{
Draw a textual table. \itemize{ \item \code{ggtexttable()}: draw
 a textual table. \item \code{ttheme()}: customize table theme. \item
 \code{rownames_style(), colnames_style(), tbody_style()}: helper functions
 to customize the table row names, column names and body. }
}
\examples{
# data
df <- head(iris)

# Default table
# Remove row names using rows = NULL
ggtexttable(df, rows = NULL)

# Blank theme
ggtexttable(df, rows = NULL, theme = ttheme("blank"))

# classic theme
ggtexttable(df, rows = NULL, theme = ttheme("classic"))

# minimal theme
ggtexttable(df, rows = NULL, theme = ttheme("minimal"))

# Medium blue (mBlue) theme
ggtexttable(df, rows = NULL, theme = ttheme("mBlue"))


# Customize the table as you want
ggtexttable(df, rows = NULL,
           theme = ttheme(
             colnames.style = colnames_style(color = "white", fill = "#8cc257"),
             tbody.style = tbody_style(color = "black", fill = c("#e8f3de", "#d3e8bb"))
           )
)

# Use RColorBrewer palette
# Provide as many fill color as there are rows in the table body, here nrow = 6
ggtexttable(df,
           theme = ttheme(
             colnames.style = colnames_style(fill = "white"),
             tbody.style = tbody_style(fill = get_palette("RdBu", 6))
           )
)

# Combine density plot and summary table
#:::::::::::::::::::::::::::::::::::::
# Density plot of "Sepal.Length"
density.p <- ggdensity(iris, x = "Sepal.Length",
                      fill = "Species", palette = "jco")

# Draw the summary table of Sepal.Length
# Descriptive statistics by groups
stable <- desc_statby(iris, measure.var = "Sepal.Length",
                     grps = "Species")
stable <- stable[, c("Species", "length", "mean", "sd")]
stable.p <- ggtexttable(stable, rows = NULL,
                       theme = ttheme("mOrange"))

# Arrange the plots on the same page
ggarrange(density.p, stable.p,
         ncol = 1, nrow = 2,
         heights = c(1, 0.5))

}
