% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-qq.r
\name{stat_qq}
\alias{geom_qq}
\alias{stat_qq}
\title{Calculation for quantile-quantile plot.}
\usage{
stat_qq(mapping = NULL, data = NULL, geom = "point",
  position = "identity", distribution = stats::qnorm, dparams = list(),
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)

geom_qq(mapping = NULL, data = NULL, geom = "point",
  position = "identity", distribution = stats::qnorm, dparams = list(),
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{distribution}{Distribution function to use, if x not specified}

\item{dparams}{Additional parameters passed on to \code{distribution}
function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Calculation for quantile-quantile plot.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("stat", "qq")}
}

\section{Computed variables}{

\describe{
  \item{sample}{sample quantiles}
  \item{theoretical}{theoretical quantiles}
}
}
\examples{
\donttest{
df <- data.frame(y = rt(200, df = 5))
p <- ggplot(df, aes(sample = y))
p + stat_qq()
p + geom_point(stat = "qq")

# Use fitdistr from MASS to estimate distribution params
params <- as.list(MASS::fitdistr(df$y, "t")$estimate)
ggplot(df, aes(sample = y)) +
  stat_qq(distribution = qt, dparams = params["df"])

# Using to explore the distribution of a variable
ggplot(mtcars) +
  stat_qq(aes(sample = mpg))
ggplot(mtcars) +
  stat_qq(aes(sample = mpg, colour = factor(cyl)))
}
}

