% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_ordibubble.R
\name{gg_ordibubble}
\alias{gg_ordibubble}
\title{Ordination Bubble Plot}
\usage{
gg_ordibubble(
  ord,
  env.var,
  groups = NA,
  var.label = "Level",
  choices = c(1, 2),
  plot = TRUE
)
}
\arguments{
\item{ord}{An ordination object}

\item{env.var}{An environmental variable.}

\item{groups}{A vector of groups (optional).}

\item{var.label}{Label for the legend; default is "Level."}

\item{choices}{Axes to be plotted.}

\item{plot}{A logical for plotting; defaults to TRUE.}
}
\value{
Silently returns the plot and data frames used for the plotting.
}
\description{
Makes a simple ordination plot of site with the symbol size
scaled to an environmental variable. Result is similar to
that of BiodiversityR's ordibubble function.
}
\examples{
data(dune)
data(dune.env)
dune.bray <- vegdist(dune, method = "bray")
ord <- cmdscale(dune.bray, k=(nrow(dune)-1), eig=TRUE, add=TRUE)
gg_ordibubble(ord, env.var=dune.env$A1, var.label="A1")

}
