% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmsa.R
\name{ggmsa}
\alias{ggmsa}
\title{ggmsa}
\usage{
ggmsa(fasta, start = NULL, end = NULL, font = "helvetica_regular",
  color = "Clustal")
}
\arguments{
\item{fasta}{Aligned FASTA format file for representing either nucleotide sequences or peptide sequences.}

\item{start}{Start position to plot, If font=NULL, only the background frame is drawn, and no character.}

\item{end}{End position to plot,If font=NULL, only the background frame is drawn, and no character.}

\item{font}{Character font, Defaults is 'helvetica_regular'.}

\item{color}{A Color scheme. One of 'Clustal', 'Chemistry_AA', 'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'Chemistry_NT', 'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Clustal'.}
}
\value{
ggplot object
}
\description{
Plot multiple sequence alignment using ggplot2 with multiple color schemes supported.
}
\examples{
#plot multiple sequence alignment
f <- system.file("extdata/sample.fasta", package="ggmsa")
ggmsa(f, 164, 213, color="Chemistry_AA")
}
\author{
guangchuang yu
}
