% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset.R
\name{inset}
\alias{inset}
\title{Add ggplot2 insets to a map}
\usage{
inset(grob, xmin = -Inf, xmax = Inf, ymin = -Inf, ymax = Inf)
}
\arguments{
\item{grob}{grob to display}

\item{xmin, xmax}{x location (in data coordinates) giving
horizontal location of raster}

\item{ymin, ymax}{y location (in data coordinates) giving vertical
location of raster}
}
\description{
This is identical to ggplot2::annotation_custom for use with
ggmap
}
\details{
Most useful for adding tables, inset plots, and other grid-based
decorations
}
\note{
\code{annotation_custom} expects the grob to fill the
  entire viewport defined by xmin, xmax, ymin, ymax. Grobs with a
  different (absolute) size will be center-justified in that
  region. Inf values can be used to fill the full plot panel
}
