% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.r
\name{letterToPolygon}
\alias{letterToPolygon}
\title{Convert an image file to a polygon}
\usage{
letterToPolygon(
  ch,
  fontfamily = "Helvetica",
  fontsize = 576,
  tol = 1,
  dim = c(480, 480),
  threshold = 0.5,
  var = "red"
)
}
\arguments{
\item{ch}{letter}

\item{fontfamily}{R has a few default fonts that are always available, such as e.g. Helvetica, Arial, Courier New, and Garamond. Other fonts might be available depending on the platform used.}

\item{fontsize}{by default 576. If the resulting string exceeds the boundary of the matrix returned, reduced font size}

\item{tol}{tolerance}

\item{dim}{vector of length two specifying width and height (in pixels) of the temporary jpg file created for the letter. Defaults to 480 x 480 pixels.}

\item{threshold}{numerical cutoff between 0 and 1}

\item{var}{one of "red", "green", "blue".}
}
\description{
Convert an image file to a polygon
}
\examples{
library(ggplot2)
letter <- letterToPolygon("R", fontfamily="Helvetica")
qplot(x, y, geom="polygon", data = letter, fill=I("black"), alpha=I(0.8))+
     coord_equal()
}
