% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_css.R
\name{girafe_css}
\alias{girafe_css}
\title{CSS creation helper}
\usage{
girafe_css(
  css,
  text = NULL,
  point = NULL,
  line = NULL,
  area = NULL,
  image = NULL
)
}
\arguments{
\item{css}{The generic css style}

\item{text}{Override style for text elements (svg:text)}

\item{point}{Override style for point elements (svg:circle)}

\item{line}{Override style for line elements (svg:line, svg:polyline)}

\item{area}{Override style for area elements (svg:rect, svg:polygon, svg:path)}

\item{image}{Override style for image elements (svg:image)}
}
\value{
css as scalar character
}
\description{
It allows specifying individual styles for various SVG elements.
}
\examples{
library(ggiraph)

girafe_css(
  css = "fill:orange;stroke:gray;",
  text = "stroke:none; font-size: larger",
  line = "fill:none",
  area = "stroke-width:3px",
  point = "stroke-width:3px",
  image = "outline:2px red"
)
}
