% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_errorbarh_interactive.R
\name{geom_errorbarh_interactive}
\alias{geom_errorbarh_interactive}
\title{Create interactive horizontal error bars}
\usage{
geom_errorbarh_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link{interactive_parameters}}.}
}
\description{
This geometry is based on \code{\link[ggplot2]{geom_errorbarh}}.
See the documentation for those functions for more details.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
  \item As aesthetics with the mapping argument (via \code{\link[ggplot2]{aes}}).
  In this way they can be mapped to data columns and apply to a set of geometries.

  \item As plain arguments into the geom_*_interactive function (see
  \code{\link[ggplot2]{layer}}). In this way they can be set to a scalar value.
}
}

\examples{
# add horizontal error bars -------
library(ggplot2)
library(ggiraph)

df <- data.frame(
  trt = factor(c(1, 1, 2, 2)),
  resp = c(1, 5, 3, 4),
  group = factor(c(1, 2, 1, 2)),
  se = c(0.1, 0.3, 0.3, 0.2)
)

# Define the top and bottom of the errorbars

p <- ggplot(df, aes(resp, trt, colour = group))
g <- p + geom_point() +
  geom_errorbarh_interactive(aes(xmax = resp + se, xmin = resp - se, tooltip = group))
x <- girafe(ggobj = g)
if( interactive() ) print(x)

g <- p + geom_point() +
  geom_errorbarh_interactive(aes(xmax = resp + se, xmin = resp - se, height = .2, tooltip = group))
x <- girafe(ggobj = g)
if( interactive() ) print(x)
}
\seealso{
\code{\link{girafe}}
}
