% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-manip.R
\name{drop_vars}
\alias{drop_vars}
\title{Drop unused variables from data}
\usage{
drop_vars(p, keep.vars = character(), guess.vars = TRUE)
}
\arguments{
\item{p}{ggplot Plot object with embedded data.}

\item{keep.vars}{character Names of unused variables to be kept.}

\item{guess.vars}{logical Flag indicating whether to find used variables
automatically.}
}
\description{
Automatically remove unused variables from the data object embedded in a
\code{gg} or \code{ggplot} object.
}
\note{
This function is under development and not yet thoroughly tested! It is
  a demonstration of how one can manipulate the internals of \code{ggplot}
  objects. This function may stop working after some future update to the
  'ggplot2' package.

  Rather than using this function after creating the \code{ggplot} object it
  may be more efficient to extract the variables of interest and pass a data
  frame containing only these to the \code{ggplot()} constructor.
}
\section{Warning!}{
 The current implementation drops variables only from the
  default data object. Data objects within layers are not modified.
}

\examples{
library(ggplot2)

p <- ggplot(mpg, aes(factor(year), (cty + hwy) / 2)) +
  geom_boxplot() +
  facet_grid(. ~ class)
p

p.dp <- drop_vars(p)
p.dp

object.size(p)
object.size(p.dp)

names(p$data)
names(p.dp$data)

}
