% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{emale_ngaros}
\alias{emale_ngaros}
\title{Integrated Ngaro retrotransposons of 6 EMALE genomes}
\format{
A data frame with 3 rows and 14 columns
\describe{
\item{file_id}{name of the file the data was read from}
\item{seq_id}{identifier of the sequence the feature appears on}
\item{start}{start of the feature on the sequence}
\item{end}{end of the feature on the sequence}
\item{strand}{orientation of the feature relative to the sequence (+ or -)}
\item{type}{feature type (CDS, mRNA, gene, ...)}
\item{feat_id}{unique identifier of the feature}
\item{introns}{a list column with internal intron start/end positions}
\item{parent_ids}{a list column with parent IDs - feat_id's of parent features}
\item{source}{source of the annotation}
\item{score}{score of the annotation}
\item{phase}{For "CDS" features indicates where the next codon begins relative to the 5' start}
\item{name}{name of the feature}
\item{geom_id}{an identifier telling the which features should be plotted as on items (usually CDS and mRNA of same gene)}
}
}
\source{
\itemize{
\item Publication: \doi{10.1101/2020.11.30.404863}
\item Raw data: \url{https://github.com/thackl/cb-emales}
\item Derived & bundled data: \code{ex("emales/emales-ngaros.gff")}
}
}
\usage{
emale_ngaros
}
\description{
Integrated Ngaro retrotransposons of 6 EMALE genomes
}
\keyword{datasets}
