% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{def_formats}
\alias{def_formats}
\title{Defined file formats and extensions}
\usage{
def_formats(
  file = NULL,
  ext = NULL,
  context = NULL,
  parser = NULL,
  allow_na = FALSE
)
}
\arguments{
\item{file}{a vector of file names}

\item{ext}{a vector of file extensions}

\item{context}{a vector of file contexts defined in
\code{gggenomes_global$def_formats}}

\item{parser}{a vector of file parsers defined in
\code{gggenomes_global$def_formats}}

\item{allow_na}{boolean}
}
\value{
dictionarish vector of file formats with recognized extensions as
names
}
\description{
For seamless reading of different file formats, gggenomes uses a mapping of
known formats to associated file extensions and contexts in which the
different formats can be read. The notion of context allows one to read
different information from the same format/extension. For example, a gbk file
holds both feature and sequence information. If read in "feats" context
\code{read_feats("*.gbk")} it will return a feature table, if read in "seqs"
context \code{read_seqs("*.gbk")}, a sequence index.
}
\section{Defined formats, extensions, contexts, and parsers}{

\preformatted{
      format                           ext            context                                              parser
1  ambigious                 txt, tsv, csv                 NA                                      read_ambigious
2      fasta fa, fas, fasta, ffn, fna, faa               seqs                                        read_seq_len
3        fai                           fai               seqs                                            read_fai
4       gff3          gff, gff3, gff2, gtf        feats, seqs                             read_gff3, read_seq_len
5        gbk           gbk, gb, gbff, gpff        feats, seqs                              read_gbk, read_seq_len
6        bed                           bed              feats                                            read_bed
7      blast                    m8, o6, o7       feats, links                              read_blast, read_blast
8        paf                           paf       feats, links                                  read_paf, read_paf
9      alitv                          json feats, seqs, links read_alitv_genes, read_alitv_seqs, read_alitv_links
10       vcf                           vcf              feats                                            read_vcf
}
}

\examples{
# vector of defined zip formats and recognized extensions as names
# format of file
def_formats("foo.fa")

# formats associated with each extension
def_formats(ext = c("fa", "gff"))

# all formats/extensions that can be read in seqs context; includes formats
# that are defined for context=NA, i.e. that can be read in any context.
def_formats(context = "seqs")
}
