% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_fan.R
\name{geom_interval}
\alias{geom_interval}
\title{Line plot visualising intervals of a distribution}
\usage{
geom_interval(mapping = NULL, data = NULL, stat = "interval_fctr",
  position = "identity", intervals = c(0, 50, 90)/100, lineend = "butt",
  linejoin = "round", linemitre = 1, arrow = NULL, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{Use to override the default use of \code{\link{stat_interval}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{intervals}{specify the collection of intervals to be represented in the
fan.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{arrow}{Arrow specification, as created by \code{\link[grid]{arrow}}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
For every value of \code{x}, computes quantiles of \code{y} and uses these to plot
intervals containing increasing proportions of the total density of \code{y}.
Boundaries of intervals are mapped to \code{linetype}. Quantiles can also be
precomputed and mapped to the aesthetic \code{quantile}.
This function is designed with the need to summarise MCMC posterior
distributions in mind.
}
\section{Aesthetics}{


\code{geom_interval} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \code{quantile}
\item \code{group}
\item \code{colour}
\item \code{size}
}
}

\examples{

library(ggplot2)
# Basic use. The data frame must have multiple y values for each
# x
ggplot(fake_df, aes(x=x,y=y)) +geom_interval()


# use precomputed quantiles - reducing storage requirements.
intervals = c(0,50,90)/100
fake_q <- calc_quantiles(fake_df, intervals=intervals)
# intervals in geom_fan must be the same as used to compute quantiles.
ggplot(fake_q, aes(x=x,y=y, quantile=quantile)) +
 geom_interval(intervals=intervals)


}
\seealso{
\code{stat_summary} Summarises y at each value of x
\code{stat_quantile} Uses quantile regression to predict quantiles
\code{geom_fan} Plot intervals on a continuous colour scale
}
