% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{maker}
\alias{maker}
\title{Canonical Linear Ballistic Accumulation/Accumualtor Model}
\usage{
maker(drifts, n, b, A, n_v, t0, st0 = 0, seed = NULL,
  return_ttf = FALSE)
}
\arguments{
\item{drifts}{a n x n_v drift rate matrix. It can be a vector with 2 or more
elements. n is the numbers of observation. n_v is the numbers of
response/accumulator.}

\item{n}{numbers of observation/model simulations. This must be a scalar.}

\item{b}{decision threshold, a vector or a scalar.}

\item{A}{start point upper bound, a vector of a scalar.}

\item{n_v}{numbers of response/accumulator, an integer. Note n_v must match
the length/size of \code{drifts} vector.}

\item{t0}{nondecision time, a vector or a scalar.}

\item{st0}{nondecision time variation, a vector of a scalar. It is the upper
bound of a uniform distribution for t0 variability.}

\item{seed}{an integer specifying if and how the random number generator
should be initialized.}

\item{return_ttf}{a boolean switch indicating if return RTs for all
accumulators. When \code{return_ttf} is TRUE, a n_v x n ttf matrix is
returned.}
}
\value{
\code{make_r} gives either a time-to-finish (ttf) matrix or a n x 2
matrix, storing RTs (first column) and responses (second column). \code{n}
equals to number of model simulations. ttf is a n_v x n matrix with RTs from
all accumulators.
}
\description{
\code{makeR} stands for making/generating/simulating responses from
a LBA model. \code{make_r} and \code{make.r} use C++ function. These
make \code{r}, \code{_r}, \code{.r} functions are essentially \code{rLBA},
including \code{rlba_norm}. They uses a LBA model with parameters, b, A,
mean_v, sd_v and t0 (no st0) to generate choice RT random deviates.
}
\details{
\code{make_v} draws drift rate from normal or truncated normal distribution.
Each trial is stored as a row and each column is a drift rate for an
accumulator. You need to transpose drift rates generated by make_v for
\code{makeR}.

\code{make.r} is a wrapper function of \code{make_r}. You may
need to use ":::" to call make.r, because of S3 method naming convention. If
you call \code{make_r} directly, beware it returns C index and is only a
numeric matrix. It does not carry a string vector for the column names, RTs
and responses. See timing test to see why it might be a good idea not to
return it as a data frame. \code{rlbaCnorm} is R version of correlated LBA
model.

\code{rlba_norm} adds checks and calls \code{make_v} and \code{make_r}.
\code{rlba_norm} is only slightly quicker than \code{make_r}.

\code{n1PDFfixedt0} is defective density function for the fisrt node LBA
model. Defective means its probability does not normally normalize to 1.
Only the probabilities from all nodes/accumulators add to 1.
\code{n1PDFfixedt0} is equation (3) on  page 159 in Brown and
Heathcote (2008).  This equation assumes st0 is 0.

\code{fptcdf} and \code{fptpdf} are distribution and density functions with
four parameters A, b, v and sv, assuming t0 is zero. \code{fptcdf} and
\code{fptpdf} are respectively equation (1) and equation (2) on page 159 in
Brown and Heathcote (2008).
}
