% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-heatmap-.R
\name{layout_heatmap}
\alias{layout_heatmap}
\alias{ggheatmap}
\title{Arrange plots around a Heatmap}
\usage{
layout_heatmap(
  data,
  mapping = aes(),
  ...,
  filling = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL,
  environment = parent.frame()
)

ggheatmap(
  data,
  mapping = aes(),
  ...,
  filling = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL,
  environment = parent.frame()
)
}
\arguments{
\item{data}{A numeric or character vector, a data frame, and any other data
which can be converted into a matrix. Simple vector will be converted into a
one column matrix.}

\item{mapping}{Default list of aesthetic mappings to use for plot. If \code{NULL},
will using \code{aes(.data$.x, .data$.y)}.}

\item{...}{Additional arguments passed to \link[ggplot2:geom_tile]{geom_tile}.
Only used when \code{filling = TRUE}.}

\item{filling}{A boolean value indicates whether to fill the heatmap. If you
want to custom the filling style, you can set to \code{FALSE}.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the layout order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}

\item{environment}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Used prior to tidy
evaluation.}
}
\value{
A \code{HeatmapLayout} object.
}
\description{
\code{ggheatmap} is an alias of \code{layout_heatmap}.
}
\section{ggplot2 specification}{

The data input in \code{ggheatmap} will be converted into the long formated data
frame when drawing. The default mapping will use \code{aes(.data$.x, .data$.y)},
you can use \code{mapping} argument to control it. The data in the underlying
\code{ggplot} object contains following columns:
\itemize{
\item \code{.xpanel} and \code{.ypanel}: the column and row panel
\item \code{.x} and \code{.y}: the \code{x} and \code{y} coordinates
\item \code{.row_names} and \code{.column_names}: A factor of the row and column names of
the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

\examples{
ggheatmap(1:10)
ggheatmap(letters)
}
