% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R
\name{hmanno}
\alias{hmanno}
\title{Determine the active context of heatmap layout}
\usage{
hmanno(
  position = NULL,
  size = NULL,
  width = NULL,
  height = NULL,
  guides = NA,
  free_labs = NA,
  free_spaces = NA,
  plot_data = NA,
  theme = NULL,
  what = waiver()
)
}
\arguments{
\item{position}{Which heatmap annotation should get activated? Possible
values are follows:
\itemize{
\item A string of \code{"top"}, \code{"left"}, \code{"bottom"}, or \code{"right"}.
\item \code{NULL}: means set the active context into the \code{heatmap} itself.
}}

\item{size}{A \link[grid:unit]{unit} object to set the total size of the heatmap
annotation. This will only be used if \code{what} is a string of \code{"top"},
\code{"left"}, \code{"bottom"}, or \code{"right"}.
\itemize{
\item If position is \code{"top"} or \code{"bottom"}, \code{size} set the total height of the
annotation.
\item If position is \code{"left"} or \code{"right"}, \code{size} set the total width of the
annotation.
}}

\item{width, height}{Heatmap body width/height, can be a \link[grid:unit]{unit}
object. Only used when \code{position} is \code{NULL}.}

\item{guides}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates Which guide should be collected. If \code{NULL}, no
guides will be collected. Default: "tlbr".}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{theme}{A \link[ggplot2:theme]{theme()} object to rendering the guides, title, subtitle, caption, margins and background. Only used when position is \code{NULL}.}

\item{what}{What should get activated for the anntoation stack? Only used
when position is not \code{NULL}. See \link{stack_active} for details.}
}
\value{
A \code{heatmap_active} object which can be added into
\link[=layout_heatmap]{HeatmapLayout}.
}
\description{
Determine the active context of heatmap layout
}
\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro()
}
