% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.gg_error}
\alias{print.gg_error}
\title{Print a \code{\link{gg_error}} object.}
\usage{
\method{print}{gg_error}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_error}} object.}

\item{...}{optional arguments

We use the tble_df command to print \code{gg_error} objects because they
tend to be long (ntree records long).}
}
\description{
Print a \code{\link{gg_error}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(iris_rf, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf_err<- gg_error(iris_rf)
print(ggrf_err)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
data(airq_rf, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf_err<- gg_error(airq_rf)
print(ggrf_err)
}
\seealso{
\code{rfsrc} \code{tbl_df} \code{\link{gg_error}}
}

