% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiConfInt}
\alias{gfiConfInt}
\title{Fiducial confidence interval}
\usage{
gfiConfInt(parameter, gfi, conf = 0.95)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest, 
like \code{~ sigma_error/`(Intercept)`}}

\item{gfi}{a \code{gfilmm} object (output of \code{\link{gfilmm}} or 
\code{\link{gfilmmPredictive}})}

\item{conf}{confidence level}
}
\value{
The fiducial confidence interval of the parameter.
}
\description{
Fiducial confidence interval of a parameter of interest.
}
\examples{
h <- 0.01
gfi <- gfilmm(~ cbind(yield-h, yield+h), ~ 1, ~ block, data = npk, N=5000)
gfiConfInt(~ sqrt(sigma_block^2 + sigma_error^2)/`(Intercept)`, gfi)
}
