% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataFromExamples.R
\name{genDataFromExamples}
\alias{genDataFromExamples}
\title{Data generation}
\usage{
genDataFromExamples(
  p,
  n,
  s = 1,
  xmean = 0,
  betamean = 0,
  betasd = 1,
  snr = 2,
  rho = 0
)
}
\arguments{
\item{p}{Number of variables (columns).}

\item{n}{Number of observations (rows).}

\item{s}{Sparsity. Real number between 0 and 1. \code{s=1} (default) leads to a coefficient vector without zero entries.}

\item{xmean}{Mean of each of the normally distributed columns. Default is 0.}

\item{betamean}{Mean of each of the normally distributed coefficients. Default is 0.}

\item{betasd}{Standard deviation of the normally distributed coefficients. Default is 1.}

\item{snr}{Signal to noise ratio. Real number greater than zero. Default is 2.}

\item{rho}{Parameter for a Toeplitz covariance structure of the regressors. Real number between -1 and 1. Default is
0 which corresponds to uncorrelated columns.}
}
\value{
\item{D}{Data matrix \eqn{(X,Y)}.}
\item{vars}{A list of the relevant variables.}
}
\description{
{Auxiliary function for generating simple artificial data sets with normally distributed coefficients
and regressors. Note that we only report this function for reproducibility of the simulations from the PhD thesis of the author.}
}
\examples{
genDataFromExamples(10,25,0.3)
}
