% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_getStorageAt}
\alias{eth_getStorageAt}
\title{Value from storage position.}
\usage{
eth_getStorageAt(address, position, number = "latest")
}
\arguments{
\item{address}{Address - Address of the storage.}

\item{position}{Integer - Position in the storage.}

\item{number}{Integer|Tag - Block number, or the string 'latest', 'earliest'
or 'pending'.}
}
\value{
Data - Value at this storage position.
}
\description{
\code{eth_getStorageAt} returns the value from a storage position at a given
address.
}
\examples{
\donttest{
eth_getStorageAt('0xcaf9a0356ddfa779fdbb55c45b22d35673550f30', '0x0')
eth_getStorageAt('0xcaf9a0356ddfa779fdbb55c45b22d35673550f30', '0x0', 'latest')
eth_getStorageAt('0xcaf9a0356ddfa779fdbb55c45b22d35673550f30', '0x0', 10)
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}}, \code{\link{eth_call}},
  \code{\link{eth_coinbase}},
  \code{\link{eth_estimateGas}},
  \code{\link{eth_gasPrice}}, \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getLogs}}, \code{\link{eth_getProof}},
  \code{\link{eth_getTransactionByBlockHashAndIndex}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleByBlockNumberAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
