% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tb_burden.R
\name{plot_tb_burden}
\alias{plot_tb_burden}
\title{Plot TB Burden by Country}
\usage{
plot_tb_burden(df = NULL, dict = NULL, metric = "e_inc_100k",
  metric_label = NULL, conf = c("_lo", "_hi"), countries = NULL,
  compare_to_region = FALSE, facet = NULL, annual_change = FALSE,
  trans = "identity", scales = "fixed", interactive = FALSE,
  download_data = TRUE, save = TRUE, burden_save_name = "TB_burden",
  dict_save_name = "TB_data_dict", verbose = TRUE, ...)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{conf}{Character vector specifying the name variations to use to specify the upper
and lower confidence intervals. Defaults to c("_lo", "_hi"), if set to \code{NULL}
then no confidence intervals are shown. When \code{annual_change = TRUE} the confidence
intervals represent the annual percentage change in the metrics confidence intervals.}

\item{countries}{A character string specifying the countries to plot.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{facet}{Character string, the name of the variable to facet by.}

\item{annual_change}{Logical, defaults to \code{FALSE}. If \code{TRUE} then the
percentage annual change is computed for the specified metric.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{scales}{Character string, see ?ggplot2::facet_wrap for details. Defaults to "fixed",
alternatives are "free_y", "free_x", or "free".}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE} then an interactive plot is
returned.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
\code{TB_burden}.}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional parameters to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A plot of TB Incidence Rates by Country
}
\description{
Plot measures of TB burden by country by specifying a metric from the TB burden data.
Specify a country or vector of countries in order to plot them (by default plots all countries).
Various other options are available for tuning the plot further.
}
\examples{

## Get the WHO TB burden data and the data dictionary
tb_burden <- get_tb_burden()
dict <- get_data_dict()

## Get a random sample of 9 countries
sample_countries <- sample(unique(tb_burden$country), 9)

## Plot incidence rates in these countries
plot_tb_burden(df = tb_burden, dict = dict, facet = "country", countries = sample_countries)
 
## Use data caching to plot incidence rates with free y scales
plot_tb_burden(facet = "country", countries = sample_countries, scales = "free_y")
 
## Plot annual percentage change in incidence rates in selected countries
plot_tb_burden(df = tb_burden, dict = dict, facet = "country", scales = "free_y", 
               countries = sample_countries, annual_change = TRUE, conf = NULL)
               
## Find variables relating to mortality in the WHO dataset
search_data_dict(def = "mortality")
## Plot mortality rates (exc HIV) - without progress messages
plot_tb_burden(metric = "e_mort_exc_tbhiv_100k", facet = "country", 
               countries = sample_countries, scales = "free_y", verbose = FALSE)
               
}
\seealso{
get_tb_burden search_data_dict
}
