% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{Weibull}
\alias{Weibull}
\title{Weibull Curve constructor function}
\usage{
Weibull(alpha, beta = 1)
}
\arguments{
\item{alpha}{Scale parameter for Weibull distribution.}

\item{beta}{Shape parameter for Weibull distribution. Default is 1; an exponential distribution.}
}
\description{
This creates a Curve object for a Weibull distribution.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
Parameterisation follows that used by pweibull etc. See Details for more information on parameterisation.
}
\details{
The Weibull distribution with shape parameter beta and scale parameter alpha has parameterisation:\cr
f(x) = (beta/alpha) (x/alpha)^(beta-1) exp(- (x/alpha)^beta)\cr
F(x) = 1 - exp(- (x/alpha)^beta)
}
\examples{
Weibull(alpha=100,beta=0.8)
}
\author{
James Bell
}
