% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{MixExp}
\alias{MixExp}
\title{Mixture Exponential Curve constructor function}
\usage{
MixExp(props, lambdas)
}
\arguments{
\item{props}{Vector of length x for the probabilities of the subpopulations. Must sum to 1.}

\item{lambdas}{Vector of length x for the rate parameters for the corresponding subpopulations define by props.}
}
\description{
This creates a Curve object for a Mixture Exponential distribution, commonly used for modelling distributions with subpopulations.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
Parameterisation follows that used by pexp etc. See Details for more information on parameterisation.
}
\details{
The mixture distribution with rates lambda1 to lambda2 etc and prevalence p1 and p2 etc has parameterisation:\cr
f(x) = p1 lambda1 e^(- lambda1 x) + p2 lambda2 e^(- lambda2 x)+...\cr
F(x) = p1 (1 - e^(- lambda1 x)) + p2 (1 - e^(- lambda2 x))+...
}
\examples{
MixExp(props=c(0.8,0.2),lambdas=c(0.01,0.1))
}
\author{
James Bell
}
