% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAbstractDBDataStore.R
\docType{class}
\name{GSAbstractDBDataStore}
\alias{GSAbstractDBDataStore}
\title{Geoserver REST API AbstractDBDataStore}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer abstract DB dataStore
}
\description{
Geoserver REST API AbstractDBDataStore

Geoserver REST API AbstractDBDataStore
}
\note{
Internal abstract class used for setting DB stores
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DB}
\keyword{DataStore}
\keyword{api}
\keyword{database}
\keyword{geoserver}
\keyword{rest}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSAbstractStore]{geosapi::GSAbstractStore}} -> \code{\link[geosapi:GSAbstractDataStore]{geosapi::GSAbstractDataStore}} -> \code{GSAbstractDBDataStore}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSAbstractDBDataStore-new}{\code{GSAbstractDBDataStore$new()}}
\item \href{#method-GSAbstractDBDataStore-setDatabaseType}{\code{GSAbstractDBDataStore$setDatabaseType()}}
\item \href{#method-GSAbstractDBDataStore-setNamespace}{\code{GSAbstractDBDataStore$setNamespace()}}
\item \href{#method-GSAbstractDBDataStore-setHost}{\code{GSAbstractDBDataStore$setHost()}}
\item \href{#method-GSAbstractDBDataStore-setPort}{\code{GSAbstractDBDataStore$setPort()}}
\item \href{#method-GSAbstractDBDataStore-setDatabase}{\code{GSAbstractDBDataStore$setDatabase()}}
\item \href{#method-GSAbstractDBDataStore-setSchema}{\code{GSAbstractDBDataStore$setSchema()}}
\item \href{#method-GSAbstractDBDataStore-setUser}{\code{GSAbstractDBDataStore$setUser()}}
\item \href{#method-GSAbstractDBDataStore-setPassword}{\code{GSAbstractDBDataStore$setPassword()}}
\item \href{#method-GSAbstractDBDataStore-setJndiReferenceName}{\code{GSAbstractDBDataStore$setJndiReferenceName()}}
\item \href{#method-GSAbstractDBDataStore-setExposePrimaryKeys}{\code{GSAbstractDBDataStore$setExposePrimaryKeys()}}
\item \href{#method-GSAbstractDBDataStore-setMinConnections}{\code{GSAbstractDBDataStore$setMinConnections()}}
\item \href{#method-GSAbstractDBDataStore-setMaxConnections}{\code{GSAbstractDBDataStore$setMaxConnections()}}
\item \href{#method-GSAbstractDBDataStore-setFetchSize}{\code{GSAbstractDBDataStore$setFetchSize()}}
\item \href{#method-GSAbstractDBDataStore-setConnectionTimeout}{\code{GSAbstractDBDataStore$setConnectionTimeout()}}
\item \href{#method-GSAbstractDBDataStore-setValidateConnections}{\code{GSAbstractDBDataStore$setValidateConnections()}}
\item \href{#method-GSAbstractDBDataStore-setPrimaryKeyMetadataTable}{\code{GSAbstractDBDataStore$setPrimaryKeyMetadataTable()}}
\item \href{#method-GSAbstractDBDataStore-setLooseBBox}{\code{GSAbstractDBDataStore$setLooseBBox()}}
\item \href{#method-GSAbstractDBDataStore-setPreparedStatements}{\code{GSAbstractDBDataStore$setPreparedStatements()}}
\item \href{#method-GSAbstractDBDataStore-setMaxOpenPreparedStatements}{\code{GSAbstractDBDataStore$setMaxOpenPreparedStatements()}}
\item \href{#method-GSAbstractDBDataStore-setEstimatedExtends}{\code{GSAbstractDBDataStore$setEstimatedExtends()}}
\item \href{#method-GSAbstractDBDataStore-setDefautConnectionParameters}{\code{GSAbstractDBDataStore$setDefautConnectionParameters()}}
\item \href{#method-GSAbstractDBDataStore-clone}{\code{GSAbstractDBDataStore$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setDescription"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setDescription'><code>geosapi::GSAbstractStore$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setEnabled"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setEnabled'><code>geosapi::GSAbstractStore$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setType"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setType'><code>geosapi::GSAbstractStore$setType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="addConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-addConnectionParameter'><code>geosapi::GSAbstractDataStore$addConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="decode"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-decode'><code>geosapi::GSAbstractDataStore$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="delConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-delConnectionParameter'><code>geosapi::GSAbstractDataStore$delConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameter'><code>geosapi::GSAbstractDataStore$setConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameters"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameters'><code>geosapi::GSAbstractDataStore$setConnectionParameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-new}{}}}
\subsection{Method \code{new()}}{
initializes an abstract DB data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$new(
  xml = NULL,
  type = NULL,
  dbType = NULL,
  name = NULL,
  description = "",
  enabled = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class} to create object from XML}

\item{\code{type}}{the type of DB data store}

\item{\code{dbType}}{DB type}

\item{\code{name}}{coverage store name}

\item{\code{description}}{coverage store description}

\item{\code{enabled}}{whether the store should be enabled or not. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setDatabaseType"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setDatabaseType}{}}}
\subsection{Method \code{setDatabaseType()}}{
Set database type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setDatabaseType(dbtype)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dbtype}}{DB type}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setNamespace}{}}}
\subsection{Method \code{setNamespace()}}{
Set namespace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setNamespace(namespace)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namespace}}{namespace}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setHost"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setHost}{}}}
\subsection{Method \code{setHost()}}{
Set host
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setHost(host)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{host}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setPort"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setPort}{}}}
\subsection{Method \code{setPort()}}{
Set port
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setPort(port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{port}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setDatabase"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setDatabase}{}}}
\subsection{Method \code{setDatabase()}}{
Set database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setDatabase(database)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{database}}{database}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setSchema"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setSchema}{}}}
\subsection{Method \code{setSchema()}}{
Set schema
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setSchema(schema)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schema}}{schema}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setUser"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setUser}{}}}
\subsection{Method \code{setUser()}}{
Set user
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setUser(user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{user}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setPassword"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setPassword}{}}}
\subsection{Method \code{setPassword()}}{
Set password
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setPassword(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{password}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setJndiReferenceName"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setJndiReferenceName}{}}}
\subsection{Method \code{setJndiReferenceName()}}{
Set JNDI reference name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setJndiReferenceName(jndiReferenceName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jndiReferenceName}}{JNDI reference name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setExposePrimaryKeys"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setExposePrimaryKeys}{}}}
\subsection{Method \code{setExposePrimaryKeys()}}{
Set expose primary keyws
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setExposePrimaryKeys(exposePrimaryKeys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{exposePrimaryKeys}}{expose primary keys}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setMinConnections"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setMinConnections}{}}}
\subsection{Method \code{setMinConnections()}}{
Set min connections
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setMinConnections(minConnections = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minConnections}}{min connections. Default is 11}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setMaxConnections"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setMaxConnections}{}}}
\subsection{Method \code{setMaxConnections()}}{
Set max connections
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setMaxConnections(maxConnections = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maxConnections}}{max connections. Default is 10}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setFetchSize"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setFetchSize}{}}}
\subsection{Method \code{setFetchSize()}}{
Set fetch size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setFetchSize(fetchSize = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fetchSize}}{fetch size. Default is 1000}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setConnectionTimeout"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setConnectionTimeout}{}}}
\subsection{Method \code{setConnectionTimeout()}}{
Set connection timeout
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setConnectionTimeout(seconds = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seconds}}{timeout (in seconds). Default is 20}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setValidateConnections"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setValidateConnections}{}}}
\subsection{Method \code{setValidateConnections()}}{
Set validate connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setValidateConnections(validateConnections)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{validateConnections}}{Validate connections}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setPrimaryKeyMetadataTable"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setPrimaryKeyMetadataTable}{}}}
\subsection{Method \code{setPrimaryKeyMetadataTable()}}{
Set primary key metadata table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setPrimaryKeyMetadataTable(primaryKeyMetadataTable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{primaryKeyMetadataTable}}{primary key metadata table}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setLooseBBox"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setLooseBBox}{}}}
\subsection{Method \code{setLooseBBox()}}{
Set loose bbox
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setLooseBBox(looseBBox = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{looseBBox}}{loose bbox. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setPreparedStatements"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setPreparedStatements}{}}}
\subsection{Method \code{setPreparedStatements()}}{
Set prepared statemnts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setPreparedStatements(preparedStatements = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{preparedStatements}}{prepared Statements. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setMaxOpenPreparedStatements"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setMaxOpenPreparedStatements}{}}}
\subsection{Method \code{setMaxOpenPreparedStatements()}}{
Set max open prepared statements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setMaxOpenPreparedStatements(
  maxOpenPreparedStatements = 50
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maxOpenPreparedStatements}}{max open preepared statements. Default is 50}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setEstimatedExtends"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setEstimatedExtends}{}}}
\subsection{Method \code{setEstimatedExtends()}}{
Set estimatedExtends
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setEstimatedExtends(estimatedExtends = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{estimatedExtends}}{estimated extends. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-setDefautConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-setDefautConnectionParameters}{}}}
\subsection{Method \code{setDefautConnectionParameters()}}{
Set default connection parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$setDefautConnectionParameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAbstractDBDataStore-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSAbstractDBDataStore-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAbstractDBDataStore$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
