% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSManager.R
\docType{class}
\name{GSManager}
\alias{GSManager}
\title{Geoserver REST API Manager}
\format{\code{\link{R6Class}} object.}
\usage{
GSManager
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoServer instance.
}
\description{
Geoserver REST API Manager
}
\section{Fields}{

\describe{
\item{\code{loggerType}}{the type of logger}

\item{\code{verbose.info}}{if geosapi logs have to be printed}

\item{\code{verbose.debug}}{if curl logs have to be printed}

\item{\code{url}}{the Base url of GeoServer}

\item{\code{version}}{the version of Geoserver. Handled as \code{GSVersion} object}
}}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate a GSManager with the \code{url} of the
   GeoServer and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger). This argument
   accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs
 }
 \item{\code{logger(type, text)}}{
   Basic logger to report geosapi logs. Used internally
 }
 \item{\code{INFO(text)}}{
   Logger to report information. Used internally
 }
 \item{\code{WARN(text)}}{
   Logger to report warnings. Used internally
 }
 \item{\code{ERROR(text)}}{
   Logger to report errors. Used internally
 }
 \item{\code{getUrl()}}{
   Get the authentication URL
 }
 \item{\code{connect()}}{
   This methods attempts a connection to GeoServer REST API. User internally
   during initialization of \code{GSManager}.
 }
 \item{\code{reload()}}{
   Reloads the GeoServer catalog.
 }
 \item{\code{getClassName()}}{
   Retrieves the name of the class instance
 }
 \item{\code{getWorkspaceManager()}}{
   Retrieves an instance of workspace manager
 }
 \item{\code{getNamespaceManager()}}{
   Retrieves an instance of namespace manager
 }
 \item{\code{getDataStoreManager()}}{
   Retrieves an instance of datastore manager
 }
}
}
\examples{
\dontrun{
   GSManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}

