% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_sample.r
\name{random.sample}
\alias{random.sample}
\title{Spatially random sample}
\usage{
random.sample(obj = NULL, poly = NULL, type, size, plotit = TRUE)
}
\arguments{
\item{obj}{a \code{sf} or \code{sp} object (with \eqn{N \geq \code{size}}) where each line corresponds to one spatial location. It should contain values of 2D coordinates, data and, optionally, covariate(s) value(s) at the locations. This argument must be provided when sampling from a \code{"discrete"} set of points, see \code{'type'} below for details.}

\item{poly}{'optional' a \code{sf} or \code{sp} polygon in which to generate the design. The default is the bounding box of points given by \code{obj}. When sampling from a \code{"continuum"}, the argument \code{'poly'} must be provided.}

\item{type}{random sampling, a choice of either \code{"discrete"}, from a set of \eqn{N} potential sampling points or \code{"continuum"} from independent, compeletely random points.}

\item{size}{a non-negative integer giving the total number of locations to be sampled.}

\item{plotit}{'logical' specifying if graphical output is required. Default is \code{plotit = TRUE}.}
}
\value{
a \code{sf} or \code{sp} object of dimension \eqn{n} by \code{p=dim(obj)[2]} containing the final sampled locations and any associated values, if sampling from a \code{"discrete"} set of points. A matrix of \eqn{n} by 2 containing sampled locations, if sampling from a \code{"continuum"}.
}
\description{
This function draws a spatially random sample from a discrete set of units located over some defined geographical region or generate completely spatially random points within a polygon.
}
\examples{
# 1. Sampling from a discrete set of points.
library("dplyr")
x <- 0.015+0.03*(1:33)
xall <- rep(x,33)
yall <- c(t(matrix(xall,33,33)))
xy <- cbind(xall,yall)+matrix(-0.0075+0.015*runif(33*33*2),33*33,2)
colnames(xy) <- c('X','Y')

# Convert to SF
xy <- xy \%>\%
  as.data.frame \%>\%
  sf::st_as_sf(coords = c(1,2))
xy <- sf::st_as_sf(xy, coords = c('X', 'Y'))


# Sampling from a discrete set.
set.seed(15892)
xy.sample <- random.sample(obj = xy, size = 100, type = "discrete", plotit = TRUE)


# Sampling from a continuum.
library("geoR")
data("parana")
poly <- parana$borders
poly <- matrix(c(poly[,1],poly[,2]),dim(poly)[1],2,byrow=FALSE)
# Convert matrix to polygon
poly <- st_sf(st_sfc(st_polygon(list(as.matrix(poly)))))

set.seed(15892)
xy.sample <- random.sample(poly = poly,size = 100, type = "continuum", plotit = TRUE)




}
\references{
Rowlingson, B. and Diggle, P. 1993 Splancs: spatial point pattern analysis code in S-Plus. Computers and Geosciences, 19, 627-655
}
\author{
Michael G. Chipeta \email{mchipeta@mlw.mw}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
