% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unnest.R
\name{geos_unnest}
\alias{geos_unnest}
\title{Unnest nested geometries}
\usage{
geos_unnest(geom, keep_empty = FALSE, keep_multi = TRUE, max_depth = 1)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{keep_empty}{If \code{TRUE}, a GEOMETRYCOLLECTION EMPTY is left as-is
rather than collapsing to length 0.}

\item{keep_multi}{If \code{TRUE}, MULTI* geometries are not expanded to sub-features.}

\item{max_depth}{The maximum recursive GEOMETRYCOLLECTION depth to unnest.}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} with a length
greater than or equal to \code{geom} with an attribute "lengths"
that can be used to map elements of the result to the
original item.
}
\description{
Unnest nested geometries
}
\examples{
geos_unnest("GEOMETRYCOLLECTION (POINT (1 2), POINT (3 4))")

}
