% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digitize2d.r
\name{digitize2d}
\alias{digitize2d}
\title{Digitize 2D landmarks on .jpg files}
\usage{
digitize2d(
  filelist,
  nlandmarks,
  scale = NULL,
  tpsfile,
  MultScale = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filelist}{A list of names of jpeg images to be digitized.}

\item{nlandmarks}{Number of landmarks to be digitized.}

\item{scale}{A vector containing the length of the scale to be placed on each image.}

\item{tpsfile}{The name of a TPS file to be created or read}

\item{MultScale}{A logical option indicating if the coordinates should be pre-multiplied by scale}

\item{verbose}{logical. User decides whether to digitize in verbose or silent format (see details), default is verbose}
}
\value{
Function returns a tps file containing the digitized landmark coordinates.
}
\description{
An interactive function to digitize two-dimensional(2D) landmarks from .jpg files.
}
\details{
This function may be used for digitizing 2D landmarks from jpeg images (.jpg). The user provides 
a list of image names, the number of landmarks to be digitized, and the name of an output
TPS file.  An option is included to allow the user to digitize a scale on each image to convert 
the landmark coordinates from pixels into meaningful units. Landmarks to be digitized can include 
both fixed landmarks and semi-landmarks, the latter of which are to be designated as "sliders" 
for subsequent analysis (see the function \code{\link{define.sliders}}).

\subsection{The Digitizing Session}{
Digitizing landmarks from 2D photos requires that a scale bar is placed in the image in order to scale the coordinate data. The 'scale' option requires: a single number (e.g. 10) which means that the scale to be measured in all images is a 10mm scale bar; OR a vector the same length as the filelist containing a number for the scale of each image. If scale=NULL, then the digitized coordinates will not be scaled. This option is NOT recommended.

Users may digitize all specimens in one session, or may return at a later time to complete digitizing. In the latter case, the user provides the same filelist and TPS file and the function will determine where the user left off. 

If specimens have missing landmarks, these can be incorporated during the digitizing process using the 'a' option as described below (a=absent).  
}


\subsection{Specimen Digitizing}{ 
Digitizing landmarks involves landmark selection using a mouse in the plot window, 
using the LEFT mouse button (or regular button for Mac users):
\enumerate{
 \item Digitize the scale bar (if requested) by selecting the two end points. Use a single click for start and end points. The
  user is asked whether the system should keep or discard the digitized scale bar. 
 \item Digitize each landmark with single click and the landmark is shown in red. 
}
If verbose = TRUE, digitizing is interactive between landmark selection using a mouse and the R console. 
Once a landmark is selected, the user is asked if the system should keep or discard the 
selection (y/n/a). If "y", the user is asked to continue to select the next landmark. If "n", the user is 
asked to select it again.

 To digitize a missing landmark, simply click on any location in the image. Then, when 
 prompted to keep selection, choose 'a' (for absent).  Missing landmarks can only be included during the digitizing process when verbose=TRUE. 
 
If verbose = FALSE the digitizing of landmarks is continuous and uninterrupted. Here the user will not be prompted to approve each landmark selection. 
 
  At the end of digitizing, the landmark coordinates are written to a TPS file. By default, the 
  x,y values are unscaled if a vector of scales is included, and the scale is returned on line 
  SCALE= after each specimen x,y data.  Optionally, one may have the coordinates pre-multiplied by
  scale by using the option MultScale=TRUE.
  }
}
\seealso{
\code{\link[jpeg]{readJPEG}} (for JPEG input)
}
\author{
Dean Adams, Erik Otarola-Castillo and Emma Sherratt
}
\keyword{digitizing}
