% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroups.R
\name{getGroups}
\alias{getGroups}
\alias{getGroups,ANY-method}
\alias{getGroups,geom-method}
\alias{getGroups,Raster-method}
\title{Get the table of group attributes}
\usage{
\S4method{getGroups}{ANY}(x)

\S4method{getGroups}{geom}(x)

\S4method{getGroups}{Raster}(x)
}
\arguments{
\item{x}{the object from which to derive the attribute table.}
}
\value{
A tibble (or a list of tibbles per layer) of the group attributes of
  \code{x}.
}
\description{
Get the table of group attributes
}
\details{
This table contains at least the column 'gid'.

  When this function is called on "ANY" object, it is first tested whether
  that object has features (\code{\link{getFeatures}}), from which the groups
  can be reconstructed. If this is not the case, \code{NULL} is returned.
}
\examples{
getGroups(x = gtGeoms$polygon)

# for raster objects, groups are pixels with the same value and their
# attributes are in the raster attribute table (RAT)
getGroups(x = gtRasters)
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
