% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setWindow.R
\name{setWindow}
\alias{setWindow}
\alias{setWindow,ANY-method}
\alias{setWindow,geom-method}
\alias{setWindow,ppp-method}
\title{Set the reference window of a spatial object.}
\usage{
\S4method{setWindow}{ANY}(x)

\S4method{setWindow}{geom}(x, to = NULL)

\S4method{setWindow}{ppp}(x, to = NULL)
}
\arguments{
\item{x}{the object for which to set a new reference window.}

\item{to}{any suitable data-structure that contains the minimum and maximum
values in x and y-dimension to which the reference window shall be set, see
Details.}
}
\value{
The object \code{x} with an update reference window.
}
\description{
Set the reference window of a spatial object.
}
\details{
Possible data-structures are \itemize{ \item an object of class
  \code{Extent}, \item an object of class \code{bbox}, \item a table with two
  columns (named x and y) containing the minimum and maximum values for each
  dimension.}
}
\examples{
# create a polygon programmatically
coords <- data.frame(x = c(40, 70, 70, 50),
                     y = c(40, 40, 60, 70))
(aGeom <- gs_polygon(anchor = coords))
visualise(aGeom)

window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
(aGeom <- setWindow(x = aGeom, to = window))

visualise(aGeom)

window <- data.frame(x = c(0, 2),
                     y = c(0, 2))
setWindow(x = gtPPP, to = window)
}
\seealso{
Other setters: 
\code{\link{setCRS}()},
\code{\link{setFeatures}()},
\code{\link{setGroups}()},
\code{\link{setHistory}()}
}
\concept{setters}
