% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryRangeElementDescription.R
\docType{class}
\name{ISOImageryRangeElementDescription}
\alias{ISOImageryRangeElementDescription}
\title{ISOImageryRangeElementDescription}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryRangeElementDescription
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOImageryRangeElementDescription
}
\description{
ISOImageryRangeElementDescription
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}]}

\item{\code{description}}{[\code{\link{character}}]}

\item{\code{rangeElement}}{[\code{\link{ISORecord}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryRangeElementDescription}}
 }
 \item{\code{setName(name, locales)}}{
   Sets the name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setDefinition(description, locales)}}{
   Sets the description. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{addRangeElement(record)}}{
   Add range element, object of class \code{\link{ISORecord}}
 }
 \item{\code{delRangeElement(record)}}{
   Deletes range element, object of class \code{\link{ISORecord}}
 }
}
}

\examples{
   #create object
   md <- ISOImageryRangeElementDescription$new()
   md$setName("name")
   md$setDefinition("description")
   md$addRangeElement("record1")
   md$addRangeElement("record2")
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{description}
\keyword{element}
\keyword{imagery}
\keyword{range}
