% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLOperationMethod.R
\docType{class}
\name{GMLOperationMethod}
\alias{GMLOperationMethod}
\title{GMLOperationMethod}
\format{\code{\link{R6Class}} object.}
\usage{
GMLOperationMethod
}
\value{
Object of \code{\link{R6Class}} for modelling an GMLOperationMethod
}
\description{
GMLOperationMethod
}
\section{Fields}{

\describe{
\item{\code{formulaCitation}}{[\code{\link{ISOCitation}}]}

\item{\code{formula}}{[\code{\link{GMLElement}}]}

\item{\code{sourceDimensions}}{[\code{\link{GMLElement}}]}

\item{\code{targetDimensions}}{[\code{\link{GMLElement}}]}

\item{\code{parameter}}{[\code{list} of [\code{\link{GMLOperationParameter}} or \code{\link{GMLOperationParameterGroup}}]]}
}}

\section{Inherited methods}{

from \code{GMLDefinition}
}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults, id)}}{
   This method is used to instantiate a GML OperationMethod
 }
 \item{\code{setFormulaCitation(citation)}}{
   Sets the formula citation, object of class \code{ISOCitation}
 }
 \item{\code{setFormula(formula)}}{
   Sets a formula, object of class \code{character}
 }
 \item{\code{setSourceDimensions(value)}}{
   Sets the number of source dimensions, object of class \code{integer}
 }
 \item{\code{setTargetDimensions(value)}}{
   Sets the number of target dimensions, object of class \code{integer}
 }
 \item{\code{addParameter(parameter)}}{
   Adds a parameter or parameter group, object of class \code{GMLOperationParameter}
   or \code{GMLOperationParameterGroup}
 }
 \item{\code{delParameter(parameter)}}{
   Deletes a parameter or parameter group, object of class \code{GMLOperationParameter}
   or \code{GMLOperationParameterGroupo}
 }
}
}

\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{method}
\keyword{operation}
