% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLCoordinateSystemAxis.R
\docType{class}
\name{GMLCoordinateSystemAxis}
\alias{GMLCoordinateSystemAxis}
\title{GMLCoordinateSystemAxis}
\format{\code{\link{R6Class}} object.}
\usage{
GMLCoordinateSystemAxis
}
\value{
Object of \code{\link{R6Class}} for modelling an GMLCoordinateSystemAxis
}
\description{
GMLCoordinateSystemAxis
}
\section{Fields}{

\describe{
\item{\code{axisAbbrev}}{[\code{\link{GMLElement}}]}

\item{\code{axisDirection}}{[\code{\link{GMLElement}}]}

\item{\code{minimumValue}}{[\code{\link{GMLElement}}]}

\item{\code{maximumValue}}{[\code{\link{GMLElement}}]}

\item{\code{rangeMeaning}}{[\code{\link{GMLElement}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults, id)}}{
   This method is used to instantiate a GML Abstract CRS
 }
 \item{\code{setAbbrev(abbrev)}}{
   Sets the axis abbreviation
 }
 \item{\code{setDirection(direction, codeSpace)}}{
   Sets the axis direction
 }
 \item{\code{setMimimumValue(value)}}{
   Sets the minimum value
 }
 \item{\code{setMaximumValue(value)}}{
   Sets the maximum value
 }
 \item{\code{setRangeMeaning(meaning, codeSpace)}}{
   Sets the range meaning
 }
}
}

\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{axis}
\keyword{coordinate}
\keyword{system}
