% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{unzip_files}
\alias{unzip_files}
\title{Unzip files}
\usage{
unzip_files(ac, subdir = NULL, delete_zip = FALSE)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{subdir}{NULL/'year'/'area', output subdir.}

\item{delete_zip}{A boolean, delete zip files if correctly unzipped.}
}
\value{
A vector of strings, name of the processed files.
}
\description{
Unzip files that are not already unzipped in the object and, if everything
went well and is indicated in the parameter, delete the unzipped files.
}
\details{
In the \code{subdir} parameter, the values NULL, 'year' or 'area' can be indicated.
With NULL it does not create any subdirs, with 'year' it creates them by years
of files and with 'area' it creates them by areas.
}
\examples{

dir <- tempdir()
source_dir <- system.file("extdata/acs_5yr", package = "geogenr")
files <- list.files(source_dir, "*.zip", full.names = TRUE)
file.copy(from = files, to = dir, overwrite = TRUE)
ac <- acs_5yr(dir)

files <- ac |>
  unzip_files()

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_groups}()},
\code{\link{get_area_years}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()}
}
\concept{data download functions}
