% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLegend.r
\docType{methods}
\name{plotLegend}
\alias{plotLegend}
\alias{plotLegend,Profile-method}
\alias{plotLegend,ProfileSet-method}
\title{Plots Legend}
\usage{
plotLegend(.Object, legend.lab = expression(paste("Resistivity [", Omega,
  " m]")), minData = 0, maxData = 999999, breaks = NULL,
  legend.line = 2.2, nlevel = 18, lab.breaks = c(), horizontal = T,
  col = colors, trafo = log, backtrafo = exp, ...)

\S4method{plotLegend}{ProfileSet}(.Object, legend.lab,
  minData = .Object@minData, maxData = .Object@maxData)

\S4method{plotLegend}{Profile}(.Object, legend.lab,
  minData = .Object@xyzData@minData, maxData = .Object@xyzData@maxData)
}
\arguments{
\item{.Object}{either a single Profile or a ProfileSet.}

\item{legend.lab}{label of legend (default: expression(paste("Resistivity [", Omega, "]"))).}

\item{minData}{minimum value.}

\item{maxData}{maximum value.}

\item{breaks}{Break points in sorted order to indicate the intervals for assigning the colors. 
Note that if there are nlevel colors there should be (nlevel+1) breakpoints. 
If breaks is not specified (nlevel+1) equally spaced breaks are created where the first and last bin have their midpoints at the minimum and maximum values in z or at zlim.}

\item{legend.line}{distance in units of character height (as in mtext) of the legend label from the color bar. 
Make this larger if the label collides with the color axis labels.}

\item{nlevel}{number of color levels.}

\item{lab.breaks}{number of breaks.}

\item{horizontal}{If false legend will be a vertical strip on the right side. If true (default) the legend strip will be along the bottom.}

\item{col}{vector of colors.}

\item{trafo}{transformation to be done on data (default: log).
For linear scale: function(x) x.}

\item{backtrafo}{back transformation to plot correct labels (default: exp).
For linear scale: function(x) x.}

\item{...}{image.plot arguments.}
}
\description{
Plots the legend for resistivity values.
}
\examples{
# data(sinkhole)

# plotLegend(sinkhole)

# for linear scale:
# plotLegend(sinkhole@profiles[[1]], 
#            trafo=function(x) x, 
#            backtrafo=function(x) x,
#            minData=100, maxData=50000)
}
\seealso{
\code{\link{Profile-class}}, \code{\link{ProfileSet-class}},
\code{\link{plot3dXyz}},
}

