% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heightAdjustment.r
\name{heightAdjustment}
\alias{heightAdjustment}
\title{Adjust Profile Height}
\usage{
heightAdjustment(Profile, deltaMeter)
}
\arguments{
\item{Profile}{a single Profile.}

\item{deltaMeter}{positive or negative value.}
}
\description{
Adjusts the height of a single profile.
GPS measurement heights might differ otherwise.
}
\examples{
# p3 <- new("Profile",
#            title = "Profile 3",
#            xyzData = 
#              new("XyzData", 
#                  address = "../example/xyzFiles/p3_DipolDipol_S-N.xyz"),
#            rawData = 
#              new("RawData",
#                  address = "../example/rawdata/p3_DipolDipol_S-N.dat"),
#            measurementType = "DipolDipol",
#            gpsCoordinates = 
#              new("GpsCoordinates",
#                  address = "../example/gps/p3.txt")) 

# p3 <- heightAdjustment(p3, -10)
}
\seealso{
\code{\link{GpsCoordinates-class}}, \code{\link{Profile-class}}
}

